package gov.va.med.mhv.usermgmt.bizobj;

import gov.va.med.mhv.usermgmt.transfer.InPersonAuthenticationCriteria;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

/**
 * Business object for the InPersonAuthenticationCriteria application entity
 *
 */
 
public class InPersonAuthenticationCriteriaBO 
    extends InPersonAuthenticationCriteriaBaseBO 
{
	
	protected void complexValidation() {
	}

	static public boolean isEmpty(InPersonAuthenticationCriteria criteria){
		return 
            StringUtils.isBlank(criteria.getFirstPlusFour()) &&
		    StringUtils.isBlank(criteria.getUsername()) &&
			StringUtils.isBlank(criteria.getFirstName()) &&
			//MHV_CodeCR1386 - Make sure that when the middle name is entered, it will be recognized as criteria not empty
			StringUtils.isBlank(criteria.getMiddleName()) &&
			StringUtils.isBlank(criteria.getLastName()) &&
			StringUtils.isBlank(criteria.getEmail()) &&
			StringUtils.isBlank(criteria.getSsn()) &&
			(criteria.getDateOfBirth() == null) &&
			StringUtils.isBlank(criteria.getMhvId()) &&
            !BooleanUtils.isTrue(criteria.getStatusAuthenticated()) &&
            !BooleanUtils.isTrue(criteria.getStatusUnauthenticated()) &&
            !BooleanUtils.isTrue(criteria.getStatusInProcess()) &&
            !BooleanUtils.isTrue(criteria.getStatusPrerequisitesComplete()) &&
            !BooleanUtils.isTrue(criteria.getStatusPendingAuthentication()) &&
            !BooleanUtils.isTrue(criteria.getStatusPendingUnauthentication()) &&
            !BooleanUtils.isTrue(criteria.getStatusPendingFailed()) &&
            !BooleanUtils.isTrue(criteria.getStatusPendingDataMismatch()) &&
        	
            //MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding Correlation status checks 
            !BooleanUtils.isTrue(criteria.getStatusMatched()) && 
            !BooleanUtils.isTrue(criteria.getStatusUnmatched()) && 
            !BooleanUtils.isTrue(criteria.getStatusCorrelated()) && 
            !BooleanUtils.isTrue(criteria.getStatusPendingCorrelation()) && 
            !BooleanUtils.isTrue(criteria.getStatusUncorrelated()) && 
            !BooleanUtils.isTrue(criteria.getStatusPendingUncorrelated()) &&
            !BooleanUtils.isTrue(criteria.getStatusFailedCorrelation()) &&
            !BooleanUtils.isTrue(criteria.getStatusFailedUncorrelation()) &&
            !BooleanUtils.isTrue(criteria.getStatusCorrelationInvalid()) &&

            (criteria.getFromAuthenticationDate() == null) &&
			(criteria.getTreatingFacilityId() == null) &&
			(criteria.getAuthenticatingFacilityInfoId() == null);
	}
    
}